#include <Servo.h>

Servo myServo;
// constaten. veranderen niet, duiden pinnummers aan
const int trigPin = 2;          // nummer van de trigPin, afstandsmeter
const int echoPin = 3;          // nummer vand de echoPin afstandsmeter
const int servoPin = 9;         // nummer vand de servoPin, servo

// variable die kan veranderen ("int" of integer, betekend: een getal, datatype)
int pos = 0;                    // begin positie 

void setup() {                  // pindeclaraties, dus inputs en outputs
  myServo.attach(servoPin);
  pinMode(trigPin, OUTPUT);
  pinMode(echoPin, INPUT);
  }

void loop() {                   //loop, alles hier in blijft herhalen. test echopin aftand
  
  digitalWrite(trigPin, LOW);   // zet afstandmeter uit
  delayMicroseconds(2);
  digitalWrite(trigPin, HIGH);  // zet afstandmeter aan
  delayMicroseconds(10);
  digitalWrite(trigPin, LOW);

  long duration = pulseIn(echoPin, HIGH);
  int distance = duration * 0.034 / 2;      //operator, berekent hoever het obstakel is op basis van de echo meting. vermenigvuldiging (*), deling (/), toewijzing (=)


  if (distance < 10) {                      // conditional statement, als de aftand minder dan 10 is dan beweegt de servo. distance is variable 
                                           
      for (pos = 0; pos <= 90; pos += 1) { // for loop. gaat van 180 graden tot 0 in stapjes van 1 (pos += 1 is operator)
    myServo.write(pos);                    // tell servo to go to position in variable 'pos'
    delay(25);                             // doet er 25 seconden over om op positie te komen
      }   
      for (pos = 90; pos >= 0; pos -= 1) { //for loop. gaat van 180 graden tot 0 in stapjes van 1 (pos -= 1 is operator)
        myServo.write(pos);                // tell servo to go to position in variable 'pos'
        delay(25);                         // doet er 25 seconden over om op positie te komen 
      }

  } else {                                 // conditional statement, als..dan..anders
    myServo.write (0);  
  }

  delay(1000);                            // Wacht 1 seconde voordat de volgende meting wordt uitgevoerd

}
